// Code generated by capnpc-go. DO NOT EDIT.

package np

import (
	strconv "strconv"
	capnp "zombiezen.com/go/capnproto2"
	text "zombiezen.com/go/capnproto2/encoding/text"
	schemas "zombiezen.com/go/capnproto2/schemas"
)

type FileBlock struct{ capnp.Struct }

// FileBlock_TypeID is the unique identifier for the type FileBlock.
const FileBlock_TypeID = 0xd5a2538369c2f82a

func NewFileBlock(s *capnp.Segment) (FileBlock, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return FileBlock{st}, err
}

func NewRootFileBlock(s *capnp.Segment) (FileBlock, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return FileBlock{st}, err
}

func ReadRootFileBlock(msg *capnp.Message) (FileBlock, error) {
	root, err := msg.RootPtr()
	return FileBlock{root.Struct()}, err
}

func (s FileBlock) String() string {
	str, _ := text.Marshal(0xd5a2538369c2f82a, s.Struct)
	return str
}

func (s FileBlock) Hash() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s FileBlock) HasHash() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s FileBlock) SetHash(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s FileBlock) Key() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s FileBlock) HasKey() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s FileBlock) SetKey(v []byte) error {
	return s.Struct.SetData(1, v)
}

// FileBlock_List is a list of FileBlock.
type FileBlock_List struct{ capnp.List }

// NewFileBlock creates a new list of FileBlock.
func NewFileBlock_List(s *capnp.Segment, sz int32) (FileBlock_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return FileBlock_List{l}, err
}

func (s FileBlock_List) At(i int) FileBlock { return FileBlock{s.List.Struct(i)} }

func (s FileBlock_List) Set(i int, v FileBlock) error { return s.List.SetStruct(i, v.Struct) }

func (s FileBlock_List) String() string {
	str, _ := text.MarshalList(0xd5a2538369c2f82a, s.List)
	return str
}

// FileBlock_Promise is a wrapper for a FileBlock promised by a client call.
type FileBlock_Promise struct{ *capnp.Pipeline }

func (p FileBlock_Promise) Struct() (FileBlock, error) {
	s, err := p.Pipeline.Struct()
	return FileBlock{s}, err
}

type File struct{ capnp.Struct }

// File_TypeID is the unique identifier for the type File.
const File_TypeID = 0xecfda38634f4591a

func NewFile(s *capnp.Segment) (File, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return File{st}, err
}

func NewRootFile(s *capnp.Segment) (File, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return File{st}, err
}

func ReadRootFile(msg *capnp.Message) (File, error) {
	root, err := msg.RootPtr()
	return File{root.Struct()}, err
}

func (s File) String() string {
	str, _ := text.Marshal(0xecfda38634f4591a, s.Struct)
	return str
}

func (s File) BlockSize() uint16 {
	return s.Struct.Uint16(0)
}

func (s File) SetBlockSize(v uint16) {
	s.Struct.SetUint16(0, v)
}

func (s File) Blocks() (FileBlock_List, error) {
	p, err := s.Struct.Ptr(0)
	return FileBlock_List{List: p.List()}, err
}

func (s File) HasBlocks() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s File) SetBlocks(v FileBlock_List) error {
	return s.Struct.SetPtr(0, v.List.ToPtr())
}

// NewBlocks sets the blocks field to a newly
// allocated FileBlock_List, preferring placement in s's segment.
func (s File) NewBlocks(n int32) (FileBlock_List, error) {
	l, err := NewFileBlock_List(s.Struct.Segment(), n)
	if err != nil {
		return FileBlock_List{}, err
	}
	err = s.Struct.SetPtr(0, l.List.ToPtr())
	return l, err
}

// File_List is a list of File.
type File_List struct{ capnp.List }

// NewFile creates a new list of File.
func NewFile_List(s *capnp.Segment, sz int32) (File_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return File_List{l}, err
}

func (s File_List) At(i int) File { return File{s.List.Struct(i)} }

func (s File_List) Set(i int, v File) error { return s.List.SetStruct(i, v.Struct) }

func (s File_List) String() string {
	str, _ := text.MarshalList(0xecfda38634f4591a, s.List)
	return str
}

// File_Promise is a wrapper for a File promised by a client call.
type File_Promise struct{ *capnp.Pipeline }

func (p File_Promise) Struct() (File, error) {
	s, err := p.Pipeline.Struct()
	return File{s}, err
}

type Link struct{ capnp.Struct }

// Link_TypeID is the unique identifier for the type Link.
const Link_TypeID = 0xe419a0e5a661965c

func NewLink(s *capnp.Segment) (Link, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Link{st}, err
}

func NewRootLink(s *capnp.Segment) (Link, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Link{st}, err
}

func ReadRootLink(msg *capnp.Message) (Link, error) {
	root, err := msg.RootPtr()
	return Link{root.Struct()}, err
}

func (s Link) String() string {
	str, _ := text.Marshal(0xe419a0e5a661965c, s.Struct)
	return str
}

func (s Link) Target() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s Link) HasTarget() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Link) TargetBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s Link) SetTarget(v string) error {
	return s.Struct.SetText(0, v)
}

// Link_List is a list of Link.
type Link_List struct{ capnp.List }

// NewLink creates a new list of Link.
func NewLink_List(s *capnp.Segment, sz int32) (Link_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return Link_List{l}, err
}

func (s Link_List) At(i int) Link { return Link{s.List.Struct(i)} }

func (s Link_List) Set(i int, v Link) error { return s.List.SetStruct(i, v.Struct) }

func (s Link_List) String() string {
	str, _ := text.MarshalList(0xe419a0e5a661965c, s.List)
	return str
}

// Link_Promise is a wrapper for a Link promised by a client call.
type Link_Promise struct{ *capnp.Pipeline }

func (p Link_Promise) Struct() (Link, error) {
	s, err := p.Pipeline.Struct()
	return Link{s}, err
}

type Special struct{ capnp.Struct }

// Special_TypeID is the unique identifier for the type Special.
const Special_TypeID = 0xdc74a897ce683c6b

func NewSpecial(s *capnp.Segment) (Special, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Special{st}, err
}

func NewRootSpecial(s *capnp.Segment) (Special, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Special{st}, err
}

func ReadRootSpecial(msg *capnp.Message) (Special, error) {
	root, err := msg.RootPtr()
	return Special{root.Struct()}, err
}

func (s Special) String() string {
	str, _ := text.Marshal(0xdc74a897ce683c6b, s.Struct)
	return str
}

func (s Special) Type() Special_Type {
	return Special_Type(s.Struct.Uint16(0))
}

func (s Special) SetType(v Special_Type) {
	s.Struct.SetUint16(0, uint16(v))
}

func (s Special) Data() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s Special) HasData() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Special) SetData(v []byte) error {
	return s.Struct.SetData(0, v)
}

// Special_List is a list of Special.
type Special_List struct{ capnp.List }

// NewSpecial creates a new list of Special.
func NewSpecial_List(s *capnp.Segment, sz int32) (Special_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return Special_List{l}, err
}

func (s Special_List) At(i int) Special { return Special{s.List.Struct(i)} }

func (s Special_List) Set(i int, v Special) error { return s.List.SetStruct(i, v.Struct) }

func (s Special_List) String() string {
	str, _ := text.MarshalList(0xdc74a897ce683c6b, s.List)
	return str
}

// Special_Promise is a wrapper for a Special promised by a client call.
type Special_Promise struct{ *capnp.Pipeline }

func (p Special_Promise) Struct() (Special, error) {
	s, err := p.Pipeline.Struct()
	return Special{s}, err
}

type Special_Type uint16

// Special_Type_TypeID is the unique identifier for the type Special_Type.
const Special_Type_TypeID = 0x8932d2d84f4dd27a

// Values of Special_Type.
const (
	Special_Type_socket   Special_Type = 0
	Special_Type_block    Special_Type = 1
	Special_Type_chardev  Special_Type = 2
	Special_Type_fifopipe Special_Type = 3
	Special_Type_unknown  Special_Type = 4
)

// String returns the enum's constant name.
func (c Special_Type) String() string {
	switch c {
	case Special_Type_socket:
		return "socket"
	case Special_Type_block:
		return "block"
	case Special_Type_chardev:
		return "chardev"
	case Special_Type_fifopipe:
		return "fifopipe"
	case Special_Type_unknown:
		return "unknown"

	default:
		return ""
	}
}

// Special_TypeFromString returns the enum value with a name,
// or the zero value if there's no such value.
func Special_TypeFromString(c string) Special_Type {
	switch c {
	case "socket":
		return Special_Type_socket
	case "block":
		return Special_Type_block
	case "chardev":
		return Special_Type_chardev
	case "fifopipe":
		return Special_Type_fifopipe
	case "unknown":
		return Special_Type_unknown

	default:
		return 0
	}
}

type Special_Type_List struct{ capnp.List }

func NewSpecial_Type_List(s *capnp.Segment, sz int32) (Special_Type_List, error) {
	l, err := capnp.NewUInt16List(s, sz)
	return Special_Type_List{l.List}, err
}

func (l Special_Type_List) At(i int) Special_Type {
	ul := capnp.UInt16List{List: l.List}
	return Special_Type(ul.At(i))
}

func (l Special_Type_List) Set(i int, v Special_Type) {
	ul := capnp.UInt16List{List: l.List}
	ul.Set(i, uint16(v))
}

type SubDir struct{ capnp.Struct }

// SubDir_TypeID is the unique identifier for the type SubDir.
const SubDir_TypeID = 0xa4a421ce00f301dd

func NewSubDir(s *capnp.Segment) (SubDir, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return SubDir{st}, err
}

func NewRootSubDir(s *capnp.Segment) (SubDir, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return SubDir{st}, err
}

func ReadRootSubDir(msg *capnp.Message) (SubDir, error) {
	root, err := msg.RootPtr()
	return SubDir{root.Struct()}, err
}

func (s SubDir) String() string {
	str, _ := text.Marshal(0xa4a421ce00f301dd, s.Struct)
	return str
}

func (s SubDir) Key() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s SubDir) HasKey() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s SubDir) KeyBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s SubDir) SetKey(v string) error {
	return s.Struct.SetText(0, v)
}

// SubDir_List is a list of SubDir.
type SubDir_List struct{ capnp.List }

// NewSubDir creates a new list of SubDir.
func NewSubDir_List(s *capnp.Segment, sz int32) (SubDir_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return SubDir_List{l}, err
}

func (s SubDir_List) At(i int) SubDir { return SubDir{s.List.Struct(i)} }

func (s SubDir_List) Set(i int, v SubDir) error { return s.List.SetStruct(i, v.Struct) }

func (s SubDir_List) String() string {
	str, _ := text.MarshalList(0xa4a421ce00f301dd, s.List)
	return str
}

// SubDir_Promise is a wrapper for a SubDir promised by a client call.
type SubDir_Promise struct{ *capnp.Pipeline }

func (p SubDir_Promise) Struct() (SubDir, error) {
	s, err := p.Pipeline.Struct()
	return SubDir{s}, err
}

type Inode struct{ capnp.Struct }
type Inode_attributes Inode
type Inode_attributes_Which uint16

const (
	Inode_attributes_Which_dir     Inode_attributes_Which = 0
	Inode_attributes_Which_file    Inode_attributes_Which = 1
	Inode_attributes_Which_link    Inode_attributes_Which = 2
	Inode_attributes_Which_special Inode_attributes_Which = 3
)

func (w Inode_attributes_Which) String() string {
	const s = "dirfilelinkspecial"
	switch w {
	case Inode_attributes_Which_dir:
		return s[0:3]
	case Inode_attributes_Which_file:
		return s[3:7]
	case Inode_attributes_Which_link:
		return s[7:11]
	case Inode_attributes_Which_special:
		return s[11:18]

	}
	return "Inode_attributes_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// Inode_TypeID is the unique identifier for the type Inode.
const Inode_TypeID = 0xc0029f81b3eee594

func NewInode(s *capnp.Segment) (Inode, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 24, PointerCount: 3})
	return Inode{st}, err
}

func NewRootInode(s *capnp.Segment) (Inode, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 24, PointerCount: 3})
	return Inode{st}, err
}

func ReadRootInode(msg *capnp.Message) (Inode, error) {
	root, err := msg.RootPtr()
	return Inode{root.Struct()}, err
}

func (s Inode) String() string {
	str, _ := text.Marshal(0xc0029f81b3eee594, s.Struct)
	return str
}

func (s Inode) Name() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s Inode) HasName() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Inode) NameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s Inode) SetName(v string) error {
	return s.Struct.SetText(0, v)
}

func (s Inode) Size() uint64 {
	return s.Struct.Uint64(0)
}

func (s Inode) SetSize(v uint64) {
	s.Struct.SetUint64(0, v)
}

func (s Inode) Attributes() Inode_attributes { return Inode_attributes(s) }

func (s Inode_attributes) Which() Inode_attributes_Which {
	return Inode_attributes_Which(s.Struct.Uint16(8))
}
func (s Inode_attributes) Dir() (SubDir, error) {
	if s.Struct.Uint16(8) != 0 {
		panic("Which() != dir")
	}
	p, err := s.Struct.Ptr(1)
	return SubDir{Struct: p.Struct()}, err
}

func (s Inode_attributes) HasDir() bool {
	if s.Struct.Uint16(8) != 0 {
		return false
	}
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s Inode_attributes) SetDir(v SubDir) error {
	s.Struct.SetUint16(8, 0)
	return s.Struct.SetPtr(1, v.Struct.ToPtr())
}

// NewDir sets the dir field to a newly
// allocated SubDir struct, preferring placement in s's segment.
func (s Inode_attributes) NewDir() (SubDir, error) {
	s.Struct.SetUint16(8, 0)
	ss, err := NewSubDir(s.Struct.Segment())
	if err != nil {
		return SubDir{}, err
	}
	err = s.Struct.SetPtr(1, ss.Struct.ToPtr())
	return ss, err
}

func (s Inode_attributes) File() (File, error) {
	if s.Struct.Uint16(8) != 1 {
		panic("Which() != file")
	}
	p, err := s.Struct.Ptr(1)
	return File{Struct: p.Struct()}, err
}

func (s Inode_attributes) HasFile() bool {
	if s.Struct.Uint16(8) != 1 {
		return false
	}
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s Inode_attributes) SetFile(v File) error {
	s.Struct.SetUint16(8, 1)
	return s.Struct.SetPtr(1, v.Struct.ToPtr())
}

// NewFile sets the file field to a newly
// allocated File struct, preferring placement in s's segment.
func (s Inode_attributes) NewFile() (File, error) {
	s.Struct.SetUint16(8, 1)
	ss, err := NewFile(s.Struct.Segment())
	if err != nil {
		return File{}, err
	}
	err = s.Struct.SetPtr(1, ss.Struct.ToPtr())
	return ss, err
}

func (s Inode_attributes) Link() (Link, error) {
	if s.Struct.Uint16(8) != 2 {
		panic("Which() != link")
	}
	p, err := s.Struct.Ptr(1)
	return Link{Struct: p.Struct()}, err
}

func (s Inode_attributes) HasLink() bool {
	if s.Struct.Uint16(8) != 2 {
		return false
	}
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s Inode_attributes) SetLink(v Link) error {
	s.Struct.SetUint16(8, 2)
	return s.Struct.SetPtr(1, v.Struct.ToPtr())
}

// NewLink sets the link field to a newly
// allocated Link struct, preferring placement in s's segment.
func (s Inode_attributes) NewLink() (Link, error) {
	s.Struct.SetUint16(8, 2)
	ss, err := NewLink(s.Struct.Segment())
	if err != nil {
		return Link{}, err
	}
	err = s.Struct.SetPtr(1, ss.Struct.ToPtr())
	return ss, err
}

func (s Inode_attributes) Special() (Special, error) {
	if s.Struct.Uint16(8) != 3 {
		panic("Which() != special")
	}
	p, err := s.Struct.Ptr(1)
	return Special{Struct: p.Struct()}, err
}

func (s Inode_attributes) HasSpecial() bool {
	if s.Struct.Uint16(8) != 3 {
		return false
	}
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s Inode_attributes) SetSpecial(v Special) error {
	s.Struct.SetUint16(8, 3)
	return s.Struct.SetPtr(1, v.Struct.ToPtr())
}

// NewSpecial sets the special field to a newly
// allocated Special struct, preferring placement in s's segment.
func (s Inode_attributes) NewSpecial() (Special, error) {
	s.Struct.SetUint16(8, 3)
	ss, err := NewSpecial(s.Struct.Segment())
	if err != nil {
		return Special{}, err
	}
	err = s.Struct.SetPtr(1, ss.Struct.ToPtr())
	return ss, err
}

func (s Inode) Aclkey() (string, error) {
	p, err := s.Struct.Ptr(2)
	return p.Text(), err
}

func (s Inode) HasAclkey() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s Inode) AclkeyBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return p.TextBytes(), err
}

func (s Inode) SetAclkey(v string) error {
	return s.Struct.SetText(2, v)
}

func (s Inode) ModificationTime() uint32 {
	return s.Struct.Uint32(12)
}

func (s Inode) SetModificationTime(v uint32) {
	s.Struct.SetUint32(12, v)
}

func (s Inode) CreationTime() uint32 {
	return s.Struct.Uint32(16)
}

func (s Inode) SetCreationTime(v uint32) {
	s.Struct.SetUint32(16, v)
}

// Inode_List is a list of Inode.
type Inode_List struct{ capnp.List }

// NewInode creates a new list of Inode.
func NewInode_List(s *capnp.Segment, sz int32) (Inode_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 24, PointerCount: 3}, sz)
	return Inode_List{l}, err
}

func (s Inode_List) At(i int) Inode { return Inode{s.List.Struct(i)} }

func (s Inode_List) Set(i int, v Inode) error { return s.List.SetStruct(i, v.Struct) }

func (s Inode_List) String() string {
	str, _ := text.MarshalList(0xc0029f81b3eee594, s.List)
	return str
}

// Inode_Promise is a wrapper for a Inode promised by a client call.
type Inode_Promise struct{ *capnp.Pipeline }

func (p Inode_Promise) Struct() (Inode, error) {
	s, err := p.Pipeline.Struct()
	return Inode{s}, err
}

func (p Inode_Promise) Attributes() Inode_attributes_Promise {
	return Inode_attributes_Promise{p.Pipeline}
}

// Inode_attributes_Promise is a wrapper for a Inode_attributes promised by a client call.
type Inode_attributes_Promise struct{ *capnp.Pipeline }

func (p Inode_attributes_Promise) Struct() (Inode_attributes, error) {
	s, err := p.Pipeline.Struct()
	return Inode_attributes{s}, err
}

func (p Inode_attributes_Promise) Dir() SubDir_Promise {
	return SubDir_Promise{Pipeline: p.Pipeline.GetPipeline(1)}
}

func (p Inode_attributes_Promise) File() File_Promise {
	return File_Promise{Pipeline: p.Pipeline.GetPipeline(1)}
}

func (p Inode_attributes_Promise) Link() Link_Promise {
	return Link_Promise{Pipeline: p.Pipeline.GetPipeline(1)}
}

func (p Inode_attributes_Promise) Special() Special_Promise {
	return Special_Promise{Pipeline: p.Pipeline.GetPipeline(1)}
}

type Dir struct{ capnp.Struct }

// Dir_TypeID is the unique identifier for the type Dir.
const Dir_TypeID = 0x8a228653b964fd48

func NewDir(s *capnp.Segment) (Dir, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 5})
	return Dir{st}, err
}

func NewRootDir(s *capnp.Segment) (Dir, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 5})
	return Dir{st}, err
}

func ReadRootDir(msg *capnp.Message) (Dir, error) {
	root, err := msg.RootPtr()
	return Dir{root.Struct()}, err
}

func (s Dir) String() string {
	str, _ := text.Marshal(0x8a228653b964fd48, s.Struct)
	return str
}

func (s Dir) Name() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s Dir) HasName() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Dir) NameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s Dir) SetName(v string) error {
	return s.Struct.SetText(0, v)
}

func (s Dir) Location() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s Dir) HasLocation() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s Dir) LocationBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s Dir) SetLocation(v string) error {
	return s.Struct.SetText(1, v)
}

func (s Dir) Contents() (Inode_List, error) {
	p, err := s.Struct.Ptr(2)
	return Inode_List{List: p.List()}, err
}

func (s Dir) HasContents() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s Dir) SetContents(v Inode_List) error {
	return s.Struct.SetPtr(2, v.List.ToPtr())
}

// NewContents sets the contents field to a newly
// allocated Inode_List, preferring placement in s's segment.
func (s Dir) NewContents(n int32) (Inode_List, error) {
	l, err := NewInode_List(s.Struct.Segment(), n)
	if err != nil {
		return Inode_List{}, err
	}
	err = s.Struct.SetPtr(2, l.List.ToPtr())
	return l, err
}

func (s Dir) Parent() (string, error) {
	p, err := s.Struct.Ptr(3)
	return p.Text(), err
}

func (s Dir) HasParent() bool {
	p, err := s.Struct.Ptr(3)
	return p.IsValid() || err != nil
}

func (s Dir) ParentBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(3)
	return p.TextBytes(), err
}

func (s Dir) SetParent(v string) error {
	return s.Struct.SetText(3, v)
}

func (s Dir) Size() uint64 {
	return s.Struct.Uint64(0)
}

func (s Dir) SetSize(v uint64) {
	s.Struct.SetUint64(0, v)
}

func (s Dir) Aclkey() (string, error) {
	p, err := s.Struct.Ptr(4)
	return p.Text(), err
}

func (s Dir) HasAclkey() bool {
	p, err := s.Struct.Ptr(4)
	return p.IsValid() || err != nil
}

func (s Dir) AclkeyBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(4)
	return p.TextBytes(), err
}

func (s Dir) SetAclkey(v string) error {
	return s.Struct.SetText(4, v)
}

func (s Dir) ModificationTime() uint32 {
	return s.Struct.Uint32(8)
}

func (s Dir) SetModificationTime(v uint32) {
	s.Struct.SetUint32(8, v)
}

func (s Dir) CreationTime() uint32 {
	return s.Struct.Uint32(12)
}

func (s Dir) SetCreationTime(v uint32) {
	s.Struct.SetUint32(12, v)
}

// Dir_List is a list of Dir.
type Dir_List struct{ capnp.List }

// NewDir creates a new list of Dir.
func NewDir_List(s *capnp.Segment, sz int32) (Dir_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 5}, sz)
	return Dir_List{l}, err
}

func (s Dir_List) At(i int) Dir { return Dir{s.List.Struct(i)} }

func (s Dir_List) Set(i int, v Dir) error { return s.List.SetStruct(i, v.Struct) }

func (s Dir_List) String() string {
	str, _ := text.MarshalList(0x8a228653b964fd48, s.List)
	return str
}

// Dir_Promise is a wrapper for a Dir promised by a client call.
type Dir_Promise struct{ *capnp.Pipeline }

func (p Dir_Promise) Struct() (Dir, error) {
	s, err := p.Pipeline.Struct()
	return Dir{s}, err
}

type UserGroup struct{ capnp.Struct }

// UserGroup_TypeID is the unique identifier for the type UserGroup.
const UserGroup_TypeID = 0xee5217621d9cbb3a

func NewUserGroup(s *capnp.Segment) (UserGroup, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return UserGroup{st}, err
}

func NewRootUserGroup(s *capnp.Segment) (UserGroup, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return UserGroup{st}, err
}

func ReadRootUserGroup(msg *capnp.Message) (UserGroup, error) {
	root, err := msg.RootPtr()
	return UserGroup{root.Struct()}, err
}

func (s UserGroup) String() string {
	str, _ := text.Marshal(0xee5217621d9cbb3a, s.Struct)
	return str
}

func (s UserGroup) Name() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s UserGroup) HasName() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s UserGroup) NameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s UserGroup) SetName(v string) error {
	return s.Struct.SetText(0, v)
}

func (s UserGroup) IyoId() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s UserGroup) HasIyoId() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s UserGroup) IyoIdBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s UserGroup) SetIyoId(v string) error {
	return s.Struct.SetText(1, v)
}

func (s UserGroup) IyoInt() uint64 {
	return s.Struct.Uint64(0)
}

func (s UserGroup) SetIyoInt(v uint64) {
	s.Struct.SetUint64(0, v)
}

// UserGroup_List is a list of UserGroup.
type UserGroup_List struct{ capnp.List }

// NewUserGroup creates a new list of UserGroup.
func NewUserGroup_List(s *capnp.Segment, sz int32) (UserGroup_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2}, sz)
	return UserGroup_List{l}, err
}

func (s UserGroup_List) At(i int) UserGroup { return UserGroup{s.List.Struct(i)} }

func (s UserGroup_List) Set(i int, v UserGroup) error { return s.List.SetStruct(i, v.Struct) }

func (s UserGroup_List) String() string {
	str, _ := text.MarshalList(0xee5217621d9cbb3a, s.List)
	return str
}

// UserGroup_Promise is a wrapper for a UserGroup promised by a client call.
type UserGroup_Promise struct{ *capnp.Pipeline }

func (p UserGroup_Promise) Struct() (UserGroup, error) {
	s, err := p.Pipeline.Struct()
	return UserGroup{s}, err
}

type ACI struct{ capnp.Struct }

// ACI_TypeID is the unique identifier for the type ACI.
const ACI_TypeID = 0xe7b4959415dabf9c

func NewACI(s *capnp.Segment) (ACI, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 24, PointerCount: 3})
	return ACI{st}, err
}

func NewRootACI(s *capnp.Segment) (ACI, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 24, PointerCount: 3})
	return ACI{st}, err
}

func ReadRootACI(msg *capnp.Message) (ACI, error) {
	root, err := msg.RootPtr()
	return ACI{root.Struct()}, err
}

func (s ACI) String() string {
	str, _ := text.Marshal(0xe7b4959415dabf9c, s.Struct)
	return str
}

func (s ACI) Uname() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s ACI) HasUname() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ACI) UnameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s ACI) SetUname(v string) error {
	return s.Struct.SetText(0, v)
}

func (s ACI) Gname() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s ACI) HasGname() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s ACI) GnameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s ACI) SetGname(v string) error {
	return s.Struct.SetText(1, v)
}

func (s ACI) Mode() uint16 {
	return s.Struct.Uint16(0)
}

func (s ACI) SetMode(v uint16) {
	s.Struct.SetUint16(0, v)
}

func (s ACI) Rights() (ACI_Right_List, error) {
	p, err := s.Struct.Ptr(2)
	return ACI_Right_List{List: p.List()}, err
}

func (s ACI) HasRights() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s ACI) SetRights(v ACI_Right_List) error {
	return s.Struct.SetPtr(2, v.List.ToPtr())
}

// NewRights sets the rights field to a newly
// allocated ACI_Right_List, preferring placement in s's segment.
func (s ACI) NewRights(n int32) (ACI_Right_List, error) {
	l, err := NewACI_Right_List(s.Struct.Segment(), n)
	if err != nil {
		return ACI_Right_List{}, err
	}
	err = s.Struct.SetPtr(2, l.List.ToPtr())
	return l, err
}

func (s ACI) Id() uint32 {
	return s.Struct.Uint32(4)
}

func (s ACI) SetId(v uint32) {
	s.Struct.SetUint32(4, v)
}

func (s ACI) Uid() int64 {
	return int64(s.Struct.Uint64(8) ^ 18446744073709551615)
}

func (s ACI) SetUid(v int64) {
	s.Struct.SetUint64(8, uint64(v)^18446744073709551615)
}

func (s ACI) Gid() int64 {
	return int64(s.Struct.Uint64(16) ^ 18446744073709551615)
}

func (s ACI) SetGid(v int64) {
	s.Struct.SetUint64(16, uint64(v)^18446744073709551615)
}

// ACI_List is a list of ACI.
type ACI_List struct{ capnp.List }

// NewACI creates a new list of ACI.
func NewACI_List(s *capnp.Segment, sz int32) (ACI_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 24, PointerCount: 3}, sz)
	return ACI_List{l}, err
}

func (s ACI_List) At(i int) ACI { return ACI{s.List.Struct(i)} }

func (s ACI_List) Set(i int, v ACI) error { return s.List.SetStruct(i, v.Struct) }

func (s ACI_List) String() string {
	str, _ := text.MarshalList(0xe7b4959415dabf9c, s.List)
	return str
}

// ACI_Promise is a wrapper for a ACI promised by a client call.
type ACI_Promise struct{ *capnp.Pipeline }

func (p ACI_Promise) Struct() (ACI, error) {
	s, err := p.Pipeline.Struct()
	return ACI{s}, err
}

type ACI_Right struct{ capnp.Struct }

// ACI_Right_TypeID is the unique identifier for the type ACI_Right.
const ACI_Right_TypeID = 0xe615914de76be38f

func NewACI_Right(s *capnp.Segment) (ACI_Right, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return ACI_Right{st}, err
}

func NewRootACI_Right(s *capnp.Segment) (ACI_Right, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return ACI_Right{st}, err
}

func ReadRootACI_Right(msg *capnp.Message) (ACI_Right, error) {
	root, err := msg.RootPtr()
	return ACI_Right{root.Struct()}, err
}

func (s ACI_Right) String() string {
	str, _ := text.Marshal(0xe615914de76be38f, s.Struct)
	return str
}

func (s ACI_Right) Right() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s ACI_Right) HasRight() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ACI_Right) RightBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s ACI_Right) SetRight(v string) error {
	return s.Struct.SetText(0, v)
}

func (s ACI_Right) Usergroupid() uint16 {
	return s.Struct.Uint16(0)
}

func (s ACI_Right) SetUsergroupid(v uint16) {
	s.Struct.SetUint16(0, v)
}

// ACI_Right_List is a list of ACI_Right.
type ACI_Right_List struct{ capnp.List }

// NewACI_Right creates a new list of ACI_Right.
func NewACI_Right_List(s *capnp.Segment, sz int32) (ACI_Right_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return ACI_Right_List{l}, err
}

func (s ACI_Right_List) At(i int) ACI_Right { return ACI_Right{s.List.Struct(i)} }

func (s ACI_Right_List) Set(i int, v ACI_Right) error { return s.List.SetStruct(i, v.Struct) }

func (s ACI_Right_List) String() string {
	str, _ := text.MarshalList(0xe615914de76be38f, s.List)
	return str
}

// ACI_Right_Promise is a wrapper for a ACI_Right promised by a client call.
type ACI_Right_Promise struct{ *capnp.Pipeline }

func (p ACI_Right_Promise) Struct() (ACI_Right, error) {
	s, err := p.Pipeline.Struct()
	return ACI_Right{s}, err
}

const schema_ae9223e76351538a = "x\xda\xacV\x7f\x88TU\x14>\xdf\xbdo~,\xcc" +
	"6\xf3z#\xfe\xc0e\xd2\x92t\xc9EW\x83\\\x8a" +
	"\xb5M\xcb\x15\x97\xbc;J\x18\x06\xbd\x9dy\xbb\xfb\x9c" +
	"\xd9\x99a\xe6M\xb2B,\x1aI.\x88\xac\xac\xfd\xc2" +
	"\xc8L\xc2\xbf*\xcc \xc9\xc8\"\x08\"\xa4$\xc1\xc2" +
	"\x8d\"m1B\x8a\x94\\p{q\xe6\xed\xbc\x99]" +
	"\xa7\xff\x9a\xbf\xee|\xef\xdc\xf3\x9d\xfb\x9d\xef\x9d\xfbV" +
	"-\x97\xeb\xc5\xea\xc0\xfd\x1a\x91Z\x15\x08\xba{.\xf4" +
	"<y\xe9B\xfb\x01\xd2\xe3\xc2\xcd<<x\xfe\x95\x93" +
	"\xcee\"\x18S\xf8\xca\x08\x88\x10\x91\x011Bp7" +
	"M\xa7\xcf$\xf7/\x1d%\x15\x81pG\x93*5y" +
	"\xef\xe1w)\x10\xe0\x90ub\x9f\xf1\x08\x07\xafY'" +
	"\xbe\x04\xe1\xef\x09\xfcu~\xc9\x89\x13z\x04u\xa1\xe0" +
	"\xd0%\xda\xeb\xc6\x0a\x8dW\xcb\xb4N\x82;~\xf5\xfa" +
	"\x07{\xdf\x14\xe78\xaf\xac\x0b\x96\x1c\xb2Q;l\xf4" +
	"p\xf0\x9an\xed)\x10\xdc\xd6[\x9f\xdb/$\x8f_" +
	"\xa4\xd9\x99+u\x1e\x08\x9c2\xc6*\xe5\x1c\x0c\xec&" +
	"\xd4N\xa3\"\xb8\xa3\x8ck\x81\xe3\xc6\x9f\x81\xf9D\xc6" +
	"T%x\xe7\xcb\xe6;W\x8f-\xbcB\x0dJ\xde\x1e" +
	"\x1c5\x9e\x09\xf2jG\x90K>\xf4Kf\xb2gl" +
	"\xde\xaf\xa4b\x80{\xf4\xd3\x1f\xe6\x8d\x1f9=9\x13" +
	"<\x1c<e\xec\xad\x04?\x1f\xe4\xc4\xfe\xe3F\xe7\x9b" +
	"\x08\xee3~\x0e\xce'Zs-x\x88\xcf\xb7h\xc7" +
	"\x8d\xb5\xfb\xdf\x9e\xfe\xbda\xcd{\xc3\xa3\xc6\x810\xaf" +
	"^\x0cs\xea\x8e\x8f\x8f\xb6\xf4\xcd\xef\xbd>7\xb8\xa2" +
	"\xc6\xcd\xf0)c\xba\x12<\x15~\x8f\xe0F~\xec(" +
	"\xac+\x97\xa6H\xdd\x0dYS}\xbb\x0cA\x83f\x8c" +
	"5\xfdF0\x8e4M\x12\xdc\xa1|\xda\xca\xb6\xa5L" +
	"Q\xc8\x15:\x92\x05+e\x9b\xd9\xb6m\xc3\x05\x8bh" +
	"+\xa0\xe2\x10D\xfa\x83\x1dD\x80\xbe\xb2\x9d\x08B_" +
	"\xd6E\x04\xa9\xb7l&\x82\xa6/\xec\"\xea,\xe5S" +
	"\x19\xcbI\xf4e\xf3\xa9\xccHj\xd0,\xa6\xad\xe7\xdc" +
	"~\xbb?_\xb09\x13\x8d\x94s\x99\\~w\xce\xa7" +
	"\x03\xd3m\xb0\x8b\x15\x92{\xa4F\xa4\x81H\xff\xb6\x95" +
	"H}-\xa1.\x09\xe8@\x1c\x0c^\xdcL\xa4\xbe\x93" +
	"P?\x09\xe8Bx%M0xYB\xdd\x12\xd0\xa5" +
	"\x8cC\x12\xe97;\x88\xd4\x1f\x12\xea\xb6\x00\xb484" +
	"\"}\x8aS\xde\x90\xe8\x85\x80\x1e\xd0\xe2\x08\x10\xe9\xd3" +
	"\x1cxK\"\xa91\x1a\x14q\x04\xd9\xfc\x18%Jj" +
	"\x90H\xc6\x18\x0f\xc9x\xa5\x17\xcd\xd8E\x94\x8c0\xbe" +
	"\x00\x02\xd1\x9c9d!B\x02\x11\x82\x9b\xcd\xa7L\xc7" +
	"\xce\xe7\x88\xc8\xc7R\xf9\x9cc\xe5\x9c\x12cw\x11\xb6" +
	"J Vk\x03\x81\xc1\xce\x82Y\xb4rNuO\xb4" +
	"d\xef\xb1\xd0D\x02M\x84N3\x95\xcdX\xc3~\xbe" +
	"\xa1|\xda\xee\xb7S&\x98h\x9b=d\x11!L\x02" +
	"a\xe6*Z\x1e\x7f\x94\x1f\xf8\xf0,\xa1\x93\xe5\xbe\x0d" +
	"\xd2.\xb2\xd6\x9a\xafu\xf3R\"\x15\x96Pq\x81\xd0" +
	"\x1c\xb6\xda\xd6\xee\\>\x0d\x8bw.\xf0w\xbe\xc6\x92" +
	"\x8eK\xa8c\x02\xd5&\xbd\xc1\xd8\xab\x12\xea\x84\x00\x04" +
	"\xea<\xa8\xbf\xf54\x09]z\x1a\xeb\x07Y\xf9\x97$" +
	"\xd4\xb8\x80\xaey\x02\xebc\xa3\xb5\x84\x95\x1e\x859\xe3" +
	".\"uTB\x9d\x9c#\xf9,\xa9\\\xd3q\x8av" +
	"_\xd9!i\x95\xfeo\xdd\x1e\xb7\xb3V\xa2\x8bM\xcd" +
	"\x02\x84}\x01V\xf0a\xef\x93P\xab\xeal\xba\x92\xf5" +
	"\\.\xa1\xd6\x0aD\x07\xcd\xd2 \x9aI\xa0\x99<q" +
	"g\xd6s\xfaR\xb0R!\xdb\xcc*\x0d\xa8\x9b\xceh" +
	"\x8d\xf2\x1b\xf8\x1f\x84>_k\x1d\x9f3\\\xb0\x10\xad" +
	"\xe5  J\x88\xa6M\xc7lL\xbd\xc5\xcee\xbcW" +
	"\xbc\xce\x11\x1d5Gt:fq\xc0r\x1a\x9b\xe2\xd1" +
	"\xc7\xba\xdb\x12\xbd\xf6\xc0\xa03G\x97\xf6\x06e\xf6\x11" +
	"\xa9\x07$\xd4C\x02\x89\"\xef\xf1s\x96KVq\xa0" +
	"\x98/S\xa8`\xa7\x11\"\x81P\x03&\xaa\xa8\xe3\xcf" +
	"a\x1d\xed\x1e\xb5Z\xec\xf3~\xc8\xbc\xefK\xa8\xb3u" +
	"\xfd8\xc3\xe0i\x09u\x8e\x1d\xe9M\x8dOX\xb3\x8f" +
	"$\xd4\x17<5\x8475>\xe3c\x9f\x9d\x19:\x1a" +
	"\xbc\xb1qq\x11\x91\xfaFB]fK\"\x8e\x00\xa0" +
	"\x7f\xbf\xb4n\x12U\xa6\x06\xa0O0xIB]\x11" +
	"H\x94\xeb\x8d\x9a\x18\x98e[>X\xf5\x94\x9d\x15%" +
	"J\xb5\xe9\xe0\x9f\xcf\x9b\x0e\xd2NW-\x19*\xdbi" +
	"\x04H \xe0V\x7fD\x14\x1ah\x84\xdei_\xaf\xc7" +
	"u-\xea\xad\xb9\xa6\xaa\xd4\xea\x8e\x99\x16m\x12p+" +
	"3<i\xef!\xd4\x8a\xad`u\xc5\xfa7\xb3W\xec" +
	"l\xd6\xed%\xab\x98x\xa2\x98/\x17\x989\xe23o" +
	"d\xed\xd7K\xa8-uM\xea\xe6&m\x90P[k" +
	"M\xea\xe1r6I\xa8ms^\xfc\x84=\x9c\xefN" +
	"W\xffu\xf2\xbf\x9c\xe3\x0f\x82Y7\x19\x8f-\xab\xcd" +
	"\x9b\x0d\xd1\xb2c\x95TLj\x8b]\x17\x1e\x85\xc9=" +
	"\xdb)\xa1\x06\x05Z\xf0\x0f\xc3\xec\x04\x8bK|VB" +
	"e\x05Z\xc4\xb4;\xe3\x05\x9b\xe1\xb4\x84*\x08\xb4\xc8" +
	"\xdb\x0c\xf3%2\xd4E\xa4\x06%\x94#\x10J\xdbE" +
	"\xc4\xaa\x9fB\x04\xc4\x08\xd1~;k!V\xbb\xe7g" +
	"\xe0\xac\x9d\xcb V\xfb\x0a\xf1\xe0\x91\x92w\xf9\"V" +
	"\xffi\xc6O\xfe\x0d\x00\x00\xff\xff\x8e\x9dO\xa6"

func init() {
	schemas.Register(schema_ae9223e76351538a,
		0x8932d2d84f4dd27a,
		0x8a228653b964fd48,
		0xa4a421ce00f301dd,
		0xc0029f81b3eee594,
		0xd5a2538369c2f82a,
		0xdc74a897ce683c6b,
		0xe419a0e5a661965c,
		0xe615914de76be38f,
		0xe7b4959415dabf9c,
		0xecfda38634f4591a,
		0xee5217621d9cbb3a,
		0xf9737539703ade0c)
}
